﻿//TODO remove setTimeouts.
//TODO use standard language resource pattern for NVW.
//TODO Refactoring to remove complexity.


//
//	FSM -> final state machine
//
//  Cet objet est utilise par le AudioMonitoring . Il definit une machine d'etat pour simplifier
//  le code java script et pour rendre le modele asynchrone.
//
//  Pour l'asynchrone nous utilisons le settimout pour liberer le thread de JQUERY et les requetes
//  ajax effectuer a l'aide de JQUERY sont asynchrone .
//
//

var AudioMonitoringFsm = {

    stateCallback: [],
    szCurrentstate: "",
    messageHandle: null,
    init: function () {

        if (this.stateCallback.length > 0) {
            return;
        }

        this.stateCallback["authenticated"] = this.authenticated;
        this.stateCallback["logincompleted"] = this.logincompleted;
        this.stateCallback["openwindow"] = this.openwindow;
        this.stateCallback["monitoringstarted"] = this.monitoringstarted;
        this.stateCallback["openwindowonhttperror"] = this.openwindowonhttperror;
        this.stateCallback["logoff"] = this.logoff;
        this.stateCallback["loginNewSession"] = this.loginNewSession;

    },

    // AudioMonitoringFsm.execute

    execute: function (state, result) {

        AudioMonitoringFsm.szCurrentstate = state;
        AudioMonitoringFsm.stateCallback[state](result);
        return;
    },


    reset: function () {
        AudioMonitoring.reset();
        AudioMonitoringFsm.szCurrentstate = "";
    },

    //
    //  methode qui permet de garder la compatibilte entre JQUERY 1.7 et 1.8 en ce qui concerne  la variable jQuery.browser
    //  A partir de 1.9 cette variable n'est plus disponible. 
    //

    JQueryBackwordCompatibility: function () {

        var rwebkit = /(webkit)[ \/]([\w.]+)/;
        var ropera = /(opera)(?:.*version)?[ \/]([\w.]+)/;
        var rmsie = /(msie) ([\w.]+)/;
        var rmozilla = /(mozilla)(?:.*? rv:([\w.]+))?/;

        var matched, browser;

        jQuery.uaMatch = function (ua) {
            ua = ua.toLowerCase();

            var match = rwebkit.exec(ua) ||
                ropera.exec(ua) ||
                rmsie.exec(ua) ||
                ua.indexOf("compatible") < 0 && rmozilla.exec(ua) ||
                [];

            return { browser: match[1] || "", version: match[2] || "0" };
        };

        matched = jQuery.uaMatch(navigator.userAgent);
        browser = {};

        if (matched.browser) {
            browser[matched.browser] = true;
            browser.version = matched.version;
        }

        // Chrome is Webkit, but Webkit is also Safari.
        if (browser.chrome) {
            browser.webkit = true;
        } else if (browser.webkit) {
            browser.safari = true;
        }

        jQuery.browser = browser;
    },

    remoteAgentDialogCallback: function (result) {

        if (result == false) {
            AudioMonitoring._debug("The supervisor has declined... Open the the interview window with audio monitoring... ", true);
            AudioMonitoring.Logoff();
            AudioMonitoringFsm.openwindow();
            return;
        }

        switch (AudioMonitoringFsm.szCurrentstate) {
            case "authenticated":
                AudioMonitoring.CompleteSignon();

                var dialog = DialogResources.Get(AudioMonitoring.SupervisorLoginParameter.m_szWaitingMessageId, AudioMonitoring.SupervisorLoginParameter, "");
                if (dialog != undefined && dialog.length != 0) {
                    messageHandle = a4.showSuccessMessage(dialog, 30000);
                }
                break;
            default:
                break;
        }
    },


    //
    //   Dans la grille de monitoring nous presente l'ensemble des agents du centre d'appel peu importe le serveur telephonique 
    //   ou l'agent travaille. Lorsque le superviseur passe de pronto x a un pronto y nous presentons un dialogue qui avertit 
    //   le superviseur qu'il doit reouvrir une session telephonique sur le pronto ou l'agent travaille.
    //
    //   reloginCallBack est appele par le dialogue  ( yes | no )
    //  
    //

    reloginCallBack: function (result) {

        if (result == false) {
            //
            //  Ne veut pas changer de pronto donc nous ouvrons quand meme la page de questionnaire pour la supervisions
            //
            AudioMonitoring._debug("The supervisor has declined to open a new telephony session. Normally this happen only when he tries to supervise agent located to another server ", true);
            AudioMonitoringFsm.openwindow();
            return;
        }

        //
        //  Nous demarrons la sequence pour permettre le re-login sur le nouveau pronto de destination.
        //


        AudioMonitoring.OpenNewSession();
        return;
    },

    loginNewSession: function (result) {

        //
        //  Si par malheur la requete nous retourne que le monitor n'etait 
        //  deja dans le systeme, nous poursuivons avec la requete de login. loginNewSession
        //  est appele seulement lorsque le superviseur change de serveur telephonique 
        //  pour la supervision de l'agent
        //
        if (result.m_bSuccess == false && result.m_szReason != "EXTENSION-NOT-SIGNED-ON") {
            AudioMonitoring.alert(result, "cannot open a new telephony session.");
            return;
        }

        AudioMonitoring.Login();
        return;
    },


    //
    //  Appele lorsque nous recevons la reponse au message de login
    //
    authenticated: function (result) {
        if (result.m_bSuccess == false) {
            //
            //  UPERVISOR-PROJECT-NOT-FOUND -> aucun project superviseur associer 
            //  NOT-SUPERVISOR-AGENT -> le supervisor n'a pas de preffered supervision module de definit a son profile.
            //  Par defaut nous ouvrons la page de supervision pour le questionnaire.
            //

            switch (result.m_szReason) {

                case "NOT-SUPERVISOR-AGENT":
                case "SUPERVISOR-PROJECT-NOT-FOUND":
                    AudioMonitoring._debug("Agent does not have supervisor access right or no supervisor module found (" + result.m_szReason + " )." + " Opening questionnaire monitoring window.", true);
                    AudioMonitoring.SupervisorLoginParameter.m_bAudioAllowed = false;
                    AudioMonitoringFsm.openwindow();
                    break;

                case "NO-REMOTE-PHONE-NUMBER":
                    Dialog.createInfoDialog(DialogResources.Get("NO-REMOTE-PHONE-NUMBER", result, result.m_szDialog), AudioMonitoringFsm.remoteAgentDialogCallback);
                    break;

                default:
                    //
                    //  Dans tous les autres cas nous affichons un message d'erreurs et nous demarrons une fenetre pour la supervision du
                    //  questionnaire.
                    //
                    AudioMonitoring.alert(result, "Authentication failed...", AudioMonitoringFsm.openwindow)
                    break;
            }

            return;
        }


        //
        //  m_szWaitingMessageId = waiting.ira |waiting.ora   -> id de recherche pour le dialog. Voir dialog.js et document.ready de la page de monitoring
        //                         Le dialog dit : please wait. The system will call you  
        //
        //

        if (result.m_szTimeout.length != 0)
            AudioMonitoring.SupervisorLoginParameter.m_iTimeout = result.m_szTimeout;

        //
        //  m_szWaitingMessageId   id pour afficher le message d'attente. 6 cas possibles
        //  waiting.ora.authentication.noaccesscode     Please wait, we are dialing your number (<number>). At the beeps, enter the following code <User PIN with #>.
        //  waiting.ora.authentication.accesscode       Please wait, we are dialing your number (<number>). At the beeps, enter the following code <code>. Then at the next set of beeps, please enter the following code: <User PIN with #>.

        //  waiting.ora.noauthentication.noaccesscode   Please wait, we are dialing your number (<number>).
        //  waiting.ora.noauthentication.accesscode     Please wait, we are dialing your number (<number>). At the beeps, enter the following code <code>.

        //  waiting.ira.noaccesscode                    We are waiting for your call. To reach out the telephony server, dial the phone number <9999>. At the beeps, please enter the following code:  <User PIN with #>.
        //  waiting.ira.accesscode                      We are waiting for your call. To reach out the telephony server, dial the phone number <9999>.  At the beeps, please enter the following code:  <code>. Then at the next set of beeps, please enter the following code: <User PIN with #>.
        //
        //  Le dialogue de message d'attente est presente par remoteAgentDialogCallback
        //
        AudioMonitoring.SupervisorLoginParameter.m_szSupervisorId = result.m_szAgentId;
        AudioMonitoring.SupervisorLoginParameter.m_bLogin = true;
        AudioMonitoring.SupervisorLoginParameter.m_szWaitingMessageId = result.m_szWaitingDialogTag;
        console.log(result.m_szWaitingDialogTag);
        AudioMonitoring.SupervisorLoginParameter.m_szSupervisorExtensionNumber = result.m_szPhoneNumber;
        AudioMonitoring.SupervisorLoginParameter.m_szSecureAccessCode = result.m_szSecureAccessCode;

        var dialogkey = result.m_szLoginType + ".dialog";
        switch (result.m_szLoginType) {

            case "ira":
            case "ora":

                //
                //  dialog qui permet de donner les instructions pour appeler le systeme ou etre appele par le systeme
                //

                var dialogmessage = DialogResources.Get(dialogkey, result, result.m_szDialog);
                Dialog.createConfirmDialog(dialogmessage, AudioMonitoringFsm.remoteAgentDialogCallback);
                break;

            case "relogin":
                //
                //  L'agent reside sur un autre serveur telephonique. Affichage du dialogue
                //  qui demande au superviseur si il veut re-ouvrir sa session telephonique.
                //
                var dialogmessage = DialogResources.Get(dialogkey, result, result.m_szDialog);
                Dialog.createConfirmDialog(dialogmessage, AudioMonitoringFsm.reloginCallBack);
                break;

            case "stationadaptorwronglocation":
                AudioMonitoring.alert(result, result.m_szDialog, AudioMonitoringFsm.openwindow);
                break;

            case "alreadyloggedin":
            case "local":

                //
                //  Si agent local ou la session telephonique est deja ouverte , nous demarrons la page web et l'audio monitoring
                //
                AudioMonitoring.StartMonitoring();
                break;
        }

    },


    openwindowonhttperror: function () {
        AudioMonitoringFsm.openwindow(null);
    },

    //
    //  logincompleted: appele lorsque nous avons eu la reponse de l'interview complete
    //
    //
    logincompleted: function (result) {

        //
        //  Le message : Veuillez patiente .. Si a l'ecran nous retirons le dialogue
        //
        setTimeout(function () { messageHandle.close(); }, 2000);
        if (result.m_bSuccess == false) {
            //
            //  Affichage du message d'erreurs . Le message harded est le message par defaut
            //
            AudioMonitoring.alert(result, "Sorry! Cannot open a telephony session for audio monitoring.", AudioMonitoringFsm.openwindow);
            return;
        }

        //
        // envoie de la requete pour le monitoruing audio
        //  
        AudioMonitoring.StartMonitoring();
        return;
    },



    //
    //  logoff: appeler lorsque nous avons recus le resultat du logoff
    //
    logoff: function (result) {

        if (result.m_bSuccess == false) {
            return;
        }

        AudioMonitoringFsm.reset();
        AudioMonitoring._debug("The supervisor has logoff...", false);
        return;
    },

    //
    //  monitoringstarted: appeler lorsque nous avons recus le resultat de la commande pour demarrer le monitoring audio pour un
    //  agent donnée
    //

    monitoringstarted: function (result) {

        if (result.m_bSuccess == false) {

            switch (result.m_szReason) {
                case "INVALID-AGENT-ID":
                    AudioMonitoring.alert(result, "Unable to start audio monitoring...", null);
                    break;
                  
                case "ALREADY-MONITORING":
                    AudioMonitoring.m_bMonitoring = true;
                    break;

                case "CONF-PLAY-CONFLICT":
                    AudioMonitoring.m_bMonitoring = true;
                default:
                    AudioMonitoring.alert(result, "Unable to start audio monitoring...", AudioMonitoringFsm.openwindow);
                    break;
            }


            return;
        }


        //
        //  Ouverture de la fenetre pour la presentation du questionnaire .
        //

        AudioMonitoring.m_bMonitoring = true;
        AudioMonitoringFsm.openwindow();
        return;
    },

    //
    //  openwindow: Ouverture de la fenetre pour la presentation du questionnaire .
    //

    openwindow: function (result) {

        var theWidth = screen.width - 10;
        var theHeight = screen.height - 10;
        var theTop = 10;
        var theLeft = 10;


        AudioMonitoring._debug("Window is now opened with url" + AudioMonitoring.page.monitoringurl, true);
        if (AudioMonitoring.page.monitoringurl.length == 0) {
        }

        var winModalWindow = window.open(AudioMonitoring.page.monitoringurl, "_blank", "scrollbars=yes,dependent=yes,resizable=yes,width=" + theWidth + ",height=" + theHeight + ",left=" + theLeft + ",top=" + theTop);
        if (winModalWindow == null) {
            return;
        }

        winModalWindow.focus();
        AudioMonitoring.page.monitoringurl = "";
        WindowsWatcher.start(winModalWindow);
        return;
    },

};


//
//  Classe qui permet de surveiller la fermeture de la fenetre de Monitoring ... Parce que l'url de intweb est 
//  different de celui de voxco.web ( cross domain policies ), nous ne pouvons pas utiliser le callback windows.unload = function() { mycallback() ; }
//

var WindowsWatcher = {

    //
    //  m_Window        -> le handle de la fenetre retourne par windows.open()
    //  m_iTimerid      -> l'id du timer .
    //

    m_Window: null,
    m_iTimerid: 0,

    //
    //  Appeler a chaque fois qu'une fenetre de monitoring est appele
    //

    start: function (myWindow) {


        //
        //  Si une fenetre est encore ouverte, nous la fermons.
        //
        if (this.m_Window != null) {
            AudioMonitoring._debug("WindowsWatcher.start> The monitoring windows still open... Closing window and stopping audio monitoring");
            this.m_Window.close();
            this.m_Window = null;
        }

        //
        //  Demarrage de l'intervale . Le callback watch est appele a toute les secondes ...
        //
        this.m_Window = myWindow;
        if (this.m_iTimerid == 0)
            this.m_iTimerid = setInterval(this.watch, 1000);
    },

    stop: function () {
        if (this.m_iTimerid != 0)
            clearInterval(this.m_iTimerid);

        this.m_iTimerid = 0;
    },

    destroy: function () {

        if (this.m_Window != null) {
            AudioMonitoring._debug("WindowsWatcher.stop> The monitorting windows still opened ... close it before unloading the document");
            this.m_Window.close();
            this.m_Window = null;
        }

        this.stop();
    },

    watch: function () {

        //
        //  Arrete du monitoring sur la fermeture de la fenetre ... TODO peut-etre arreter le timer 
        //  l'interval et le redemarrer sur le start si probleme de ressources
        //  
        if (WindowsWatcher.m_Window != null && WindowsWatcher.m_Window.closed == true) {
            AudioMonitoring._debug("watch> The monitoring windows has been closed... stopping monitoring", true);
            AudioMonitoring.StopMonitoring(true);
            WindowsWatcher.m_Window = null;
        }
    }
};


//
// Cette objet a la responsabilite d'envoyer les messages et requete lie a la supervision audio du systeme telephonique 
//
//  SetIE8Compatibility: permet de garder un compatibilite entre  IE8 et le version plus recente
//
//  unload                      :   appelle lorsque la page de monitoring n'est plus disponible 
//  MonitoringButtonOnClick     :   Click du bouton monitor dans la page de minitoring 
//  init                        :   Initialsation de l'objet . Appelle au document load
//  CollectMonitoringParameters :   Appele lorsque le supervisor a selection un agent
//  isAudioMonitoringEnable     :   Determine si la supervision audio est disponible
//  CreateSession               :   Appeler au chargement de la page de monitoring 
//  Login                       :   Envoie de la requete de login
//  screenMonitoringClick       : 
//
//  CompleteSignon              :   Envoie du message complete signon lorsque le supervisor est considere comme "remote"
//  StartMonitoring             :   Demarrage de la supervison audio pour un agent donnee
//  getHttpError                :   permet de formatter l'erreur HTTP
//
//  OpenNewSession              :   Ouvre une nouvelle session telephonique si la supervision audio passe de pronto x a un pronto y
//  Logoff                      :   fin de la session supervisor
//  StopMonitoring              :   Arret de la supervision audio pour un agent donné
//  _debug                      :   Trace a la console de l'ecran et envoie un log du cote serveur
//  _error                      :   Trace les erreurs 
// 

var AudioMonitoring = {

    sessions: { agentid: 0, projectid: 0, prontoid: 0, audiomonitoringenable: true },
    page: { url: "", monitoringurl: "" },
    workstationId: $("#workstationId").attr("data-workstationId"),
    m_bMonitoring: false,
    SupervisorLoginParameter: {
        m_bAutheticationRequiered: true,
        m_bAudioAllowed: true,
        m_iTimeout: 60000,
        m_szLoginType: "",
        m_szSupervisorId: "",
        m_szContext: "",
        m_szWorkstationId: workstationId,
        m_szSessionGuid: "",
        m_szProntoId: "",
        m_szMode: "listen" ,
        m_bLogin: false,
        m_szSupervisorExtensionNumber: "",
        m_szSecureAccessCode: ""
    },
    MoniterDataParameter: { m_szAgentd: "", m_szProntoId: "", m_szProjectId: "" },
    alertEnable: ["monitor-stop", "open-new-session", "supervisor-signon", "complete-remote-signon", "monitor-start"],



    //
    //  garde une compatibilite  avec IE8. index of n'existe pas avec IE8
    //
    SetIE8Compatibility: function () {

        if (Array.prototype.indexOf != undefined && Array.prototype.indexOf != null) {
            return;
        }

        Array.prototype.indexOf = function (elt /*, from*/) {

            var len = this.length >>> 0;
            var from = Number(arguments[1]) || 0;

            from = (from < 0) ? Math.ceil(from) : Math.floor(from);
            if (from < 0)
                from += len;

            for (; from < len; from++) {
                if (from in this &&
                    this[from] === elt)
                    return from;
            }

            return -1;
        };
    },


    //
    //  La page du monitoring n'est plus disponible  donc nous arretons le monitoring audio au cas ou
    //
    unload: function () {

        if (AudioMonitoring.isAudioMonitoringEnable("unload") == false) {
            return;
        }

        //
        //  Arret du monitoring a la sortie de la page 
        //  Arret de l'intervale de surveillance de la fenetre de monitoring.
        //
        AudioMonitoring.StopMonitoring(false);
        WindowsWatcher.destroy();
    },



    MonitoringButtonOnClick: function () {
        AudioMonitoring._debug("Monitor button click detected ... trying to authenticate the supervisor id " + AudioMonitoring.SupervisorLoginParameter.m_szSupervisorId);
        AudioMonitoring.Login();
    },


    //
    //  monitoringurl   : L'url qui permet d'ouvrir la fenetre pour la supervison du questionnaire  
    //

    init: function (monitoringurl, action) {

        this.SetIE8Compatibility();

        if (typeof action == "string")
            this.SupervisorLoginParameter.m_szMode = action;

        AudioMonitoringFsm.init();
        if (monitoringurl != undefined && monitoringurl != null)
            this.page.monitoringurl = monitoringurl;
    },

    reset: function () {
        this.SupervisorLoginParameter.m_bLogin = true;
    },

    //
    //  data            : contient les donnees relative a la selection de l'agent. Format  name1=value&name2=Vvalue... nameN=value&nameN+1=value
    //  bSelected       :  ( true | false ) est-ce que l'agent est selectionne ou non
    //  monitoringurl   : contient l'url pour la creation de la fenetre de monitoring
    //

    CollectMonitoringParameters: function (monitoringurl, data, bSelected) {

        var parameters = data.split("&");
        var bLog = false;

        if (bSelected == true)
            this.page.monitoringurl = monitoringurl;

        for (index = 0 ; index < parameters.length ; index++) {

            var parameter = parameters[index].split("=");
            if (parameter.length < 2)
                continue;

            var name = parameter[0];
            var value = parameter[1];

            switch (name) {
                case "AgentUserID":
                    if (this.MoniterDataParameter.m_szAgentd == value && bSelected == false) {
                        this.MoniterDataParameter.m_szAgentd = "";
                        break;
                    }
                    if (this.MoniterDataParameter.m_szAgentd != value) {
                        this.MoniterDataParameter.m_szAgentd = value;
                        bLog = true;
                    }
                    break;
                case "ProntoID":
                    //
                    //  le pronto sur lequel l'agent travaille 
                    //
                    if (this.MoniterDataParameter.m_szProntoId == value && bSelected == false) {
                        this.MoniterDataParameter.m_szProntoId = "";
                        break;
                    }
                    //
                    // Si le pronto est different , nous forcons un re-loging
                    //
                    if (this.MoniterDataParameter.m_szProntoId == 0 || this.MoniterDataParameter.m_szProntoId != value) {
                        this.SupervisorLoginParameter.m_bLogin = false;
                    }
                    this.SupervisorLoginParameter.m_szProntoId = value;
                    this.MoniterDataParameter.m_szProntoId = value;
                    break;
                case "ProjectID":
                    //
                    //  Le projet est celui du cati.
                    //
                    if (this.MoniterDataParameter.m_szProjectId == value && bSelected == false) {
                        this.MoniterDataParameter.m_szProjectId = "";
                        break;
                    }
                    this.MoniterDataParameter.m_szProjectId = value;
                    break;
                default:
                    break;
            }
        }

        if (bLog == true)
            this._debug("Supervisor has selected agent id " + this.MoniterDataParameter.m_szAgentd, " located on prontoserver id ", +this.MoniterDataParameter.m_szProntoId);
    },

    //
    // Cette methode permet de verifier si l'audio monitoring est disponible pour ce supervisor. Deux possibilite
    //  
    //  1) Rien de configurer dans le fichier app.config
    //  2) Le superiviseur n'a pas les droits ( preferred supervisor module ). Profile de l'agent.
    //
    //

    isAudioMonitoringEnable: function (szCallMethod) {

        var bEnable = true;

        if (szCallMethod == undefined || szCallMethod == null)
            szCallMethod = "";

        if (AudioMonitoring.SupervisorLoginParameter.m_szProntoId == "0" || AudioMonitoring.SupervisorLoginParameter.m_szProntoId.length == 0) {

            //
            //  Si pas de pronto ID c'est probablement parce que nous sommes en cati seulement ;
            //

            AudioMonitoring._debug("There is no prontoid associated with the agent... Might be a cati project only");
            return false;
        }
        //
        //  AudioMonitoring.SupervisorLoginParameter.m_bAudioAllowed == false lorsque la reponse du login est 
        //  NOT-SUPERVISOR-AGENT
        //
        //  AudioMonitoring.sessions.audiomonitoringenable == false lorsque nous n'avons aucun point de connexion 
        //  ( Address IP + TCP port ) de configurer dans le app.conf
        //
        //

        if (AudioMonitoring.SupervisorLoginParameter.m_bAudioAllowed == false || AudioMonitoring.sessions.audiomonitoringenable == false) {
            AudioMonitoring._debug("(" + szCallMethod + ")" + " Audio monitoring is not allowed ... m_bAudioAllowed = " +
                                    AudioMonitoring.SupervisorLoginParameter.m_bAudioAllowed +
                                    " and audiomonitoringenable == " + AudioMonitoring.sessions.audiomonitoringenable);
            bEnable = false;
        }

        return bEnable;
    },

    //
    //  Creation de la session du superviseur. Cette methode est appele au chargement de la page de supervisions
    //
    //  supervisorid:  Id du superviseur 
    //  sessionguid :  id de session . Normalement récuperé au login de command-center
    //  
    //

    CreateSession: function (ajaxControllerUrl) {
        if (ajaxControllerUrl != undefined && ajaxControllerUrl != null)
            this.page.url = ajaxControllerUrl;

        var action = this.page.url + "CreateMonitoringSession";
        a4.callServerMethod(action, { workstationId: this.workstationId },
                function (_result) {
                    _result = JSON.parse(_result);
                    switch (_result.m_szReason) {
                        case "disable":
                            setTimeout(function () { AudioMonitoring._debug("IE: The audio monitoring is disable. Please verify the web.config file for MonitoringVoxcoBridgeServerAddress. If not defined or empty the service be considered has disable"); }, 1);
                            AudioMonitoring.sessions.audiomonitoringenable = false;
                            break;
                        case "DISPATCHER-NOT-CREATED":
                            setTimeout(function () { AudioMonitoring._debug("Cannot create session: DISPATCHER-NOT-CREATED."); }, 1);
                            AudioMonitoring.sessions.audiomonitoringenable = false;
                            break;
                        case "failed":
                        case "success":
                        default:
                            AudioMonitoring.sessions.audiomonitoringenable = true;
                            break;
                    }

                    AudioMonitoring.SupervisorLoginParameter.m_szWorkstationId = _result.m_szWorktstaionId;
                    return;
                },

                function (_xhr, msg, e) {

                    var message = AudioMonitoring.getHttpError(_xhr, msg, e);
                    AudioMonitoring._error("Sorry! Unable to create a telephony session. The request failed to be sent to server. Reason " + message);
                } 
            );
        return;
    },



    //
    //  Ouverture de la session telephonique du superviseur. Les donnees essentielles sont :
    // 
    //  SupervisorLoginParameter.m_szSupervisorId 
    //  SupervisorLoginParameter.m_szSessionGuid
    //  
    //

    Login: function ( action ) {

        if (action == "view" || this.isAudioMonitoringEnable("Login") == false    ) {
            setTimeout(function () { AudioMonitoringFsm.execute("openwindow", null); }, 1);
            return;
        }

        //
        //  Le settimeout permet de passer d'un etat a un autre et de garder une certain independance sur la page puisque 
        //  sa rend le processus asynchrone. 
        //
        //  Le settimeout permet de liberer les resources de JQUERY et elimine les problemes lies a la recursivite
        //

        this._debug("sending login request with timeout of " + this.SupervisorLoginParameter.m_iTimeout + " ms", true);
        var action = this.page.url + "SupervisorLogin";
        a4.callServerMethod(action,
            {
                workstationId: this.SupervisorLoginParameter.m_szWorkstationId,
                mode: this.SupervisorLoginParameter.m_szMode,
                prontoId: this.SupervisorLoginParameter.m_szProntoId,
                context: this.SupervisorLoginParameter.m_szContext,
                timeout: this.SupervisorLoginParameter.m_iTimeout,
            },
            function (_result) {
                _result = $.parseJSON(_result);
                setTimeout(function () { AudioMonitoringFsm.execute("authenticated", _result); }, 1);
                return;
            },
            function (_xhr, msg, e) {

                var message = AudioMonitoring.getHttpError(_xhr, msg, e);
                AudioMonitoring.httpAlert("http.error", "supervisor-signon", message)
            }
         );
    },


    //
    //  Essentiel pour la vieille version de command center . Appeler si le button monitor est cliqué 
    //

    screenMonitoringClick: function () {
        AudioMonitoringFsm.init();
        setTimeout(function () { AudioMonitoringFsm.execute("openwindow", null); }, 1);
    },


    //
    //  Si le superviseur est un remote agent , le complete signon permet d'afficher une boite de dialog qui lui donne
    //  les informations pour ouvrir sa session telephonique .
    //
    //  Le dialog comprend 
    //
    //      1) Numero de telephone pour rejoindre le serveur telephonique 
    //      2) Le code a compose pour s'authentifier
    //



    CompleteSignon: function () {
        //
        //  Le settimeout permet de passer d'un etat a un autre et de garder une certain independance sur la page puisque 
        //  sa rend le processus asynchrone. 
        //
        //  Le settimeout permet de liberer les resources de JQUERY et elimine les problemes lies a la recursivite
        //
        var action = this.page.url + "CompleteMonitoringSignon";
        a4.callServerMethod(action,
            {
                prontoId: this.SupervisorLoginParameter.m_szProntoId,
                timeout: this.SupervisorLoginParameter.m_iTimeout
            },
            function (_result) {
                _result = $.parseJSON(_result);

                if (messageHandle !== null) {
                    messageHandle.close();
                }

                setTimeout(function () { AudioMonitoringFsm.execute("logincompleted", _result); }, 1);
            },
            function (_xhr, msg, e) {
                var message = AudioMonitoring.getHttpError(_xhr, msg, e);
                AudioMonitoring.httpAlert("http.error", "complete-remote-signon", message)
            }
        );
    },

    //
    //  Demarrage du monitoring audio sur un agent donné
    //
    //  MoniterDataParameter.m_szAgentd
    //  MoniterDataParameter.m_szProntoId
    //  SupervisorLoginParameter.m_szSupervisorId
    //
    //  Ces informations sont ramasses  avec la méthode CollectMonitoringParameters. Cette methode est
    //  appele lors que l'agent est choisi
    //
    //
    //


    StartMonitoring: function (data) {

        if (this.isAudioMonitoringEnable("StartMonitoring") == false) {
            setTimeout(function () { AudioMonitoringFsm.execute("openwindow", null); }, 1);
            return;
        }

        this._debug("Sending start monitoring ... target agent id is " + this.MoniterDataParameter.m_szAgentd,
                     " located on prontoserver id ", +this.MoniterDataParameter.m_szAgentd, this.MoniterDataParameter.m_szProntoId);

        var action = this.page.url + "StartMonitoring";

        a4.callServerMethod(action, { agentId: this.MoniterDataParameter.m_szAgentd, mode: this.SupervisorLoginParameter.m_szMode },
               function (_result) {
                   _result = $.parseJSON(_result);
                   AudioMonitoring._debug("Start monitoring successful");
                   setTimeout(function () { AudioMonitoringFsm.execute("monitoringstarted", _result); }, 1);
                   return;
               },
               function (_xhr, msg, e) {

                   var message = AudioMonitoring.getHttpError(_xhr, msg, e);
                   AudioMonitoring.httpAlert("http.error", "monitor-start", message)
                   return;

               }
           );

        return;
    },


    //
    //  Si une erreur http , nous formattons le message d'erreur
    //
    getHttpError: function (_xhr, msg, exception) {

        var reason = "unknown reason ";

        if (exception != undefined && exception != null)
            reason = exception + " ";


        if (_xhr != undefined && _xhr != null) {
            reason += " -- http status " + _xhr.status;
        }


        return reason;
    },


    //
    //  Open new session est appele si est seulement le supervisor tente d'effectuer la supervision
    //  d'un agent localiser sur un autre pronto.
    //

    OpenNewSession: function () {

        this._debug("Before opening a new session we need to close the current session");

        var action = this.page.url + "SignoffMonitoring";
        a4.callServerMethod(action, {},
               function (_result) {
                   //
                   //  parce que la methode error fait egalement une requete HTTP , nous effectuons la requete en different pour libere 
                   //  la resource utiliser par JQUERY.
                   //
                   _result = $.parseJSON(_result);
                   setTimeout(function () { AudioMonitoringFsm.execute("loginNewSession", _result); }, 1);
                   return;
               },
               function (_xhr, msg, e) {

                   var message = AudioMonitoring.getHttpError(_xhr, msg, e);
                   AudioMonitoring.httpAlert("http.error", "open-new-session", message);
               }
           );

    },

    Logoff: function (reason) {

        if (this.SupervisorLoginParameter.m_bLogin == false)
            return;

        this._debug("Supervisor has signed off ...reason:" + reason);

        var action = this.page.url + "SignoffMonitoring";
        a4.callServerMethod(action , {},
               function (_result) {
                   //
                   //  parce que la methode error fait egalement une requete HTTP , nous effectuons la requete en different pour libere 
                   //  la resource utiliser par JQUERY.
                   // 
                   _result = $.parseJSON(_result);
                   setTimeout(function () { AudioMonitoringFsm.execute("logoff", _result); }, 1);
                   return;
               },
               function (_xhr, msg, e) {
                   var message = AudioMonitoring.getHttpError(_xhr, msg, e);
                   AudioMonitoring._error("The HTTP request failed for supervisor logoff request... Reason  " + message, true);
               }
           );


    },

    //
    //  Arret du monitoring ...
    //
    StopMonitoring: function (bAsync) {

        if (this.m_bMonitoring == false) {
            this._debug("No need to stop agent monitoring because supervisor is not listening...");
            return;
        }

        this._debug("Sending stop monitoring ... target agent id is " + this.MoniterDataParameter.m_szAgentd, " located on prontoserver id ",
                    +this.MoniterDataParameter.m_szAgentd, this.MoniterDataParameter.m_szProntoId);

        var action = this.page.url + "StopMonitoring";
        a4.callServerMethod(action, {},

               function (_result) {
                   _result = $.parseJSON(_result);
                   if (_result.m_bSuccess == false && _result.m_szReason != "NO-SESSION" && _result.m_szReason != "AGENT.NOT.REGISTER") {
                       AudioMonitoring.alert(_result, "stopping monitoring agent " + AudioMonitoring.MoniterDataParameter.m_szAgentd + "failed");
                   }

                   AudioMonitoring.m_bMonitoring = false;
                   return;
               },

               function (_xhr, msg, e) {

                   var message = AudioMonitoring.getHttpError(_xhr, msg, e);
                   AudioMonitoring.httpAlert("http.error", "monitor-stop", message);
               }
           );

        return;
    },



    //
    //  Methode qui permet de tracer les operations de supervisions
    //

    _debug: function (_data, bLog) {


        //
        //  Console pas defini avec IE8 mode enterprise...
        //
        if (typeof console != "undefined")
            console.log("debug: " + _data);

        //
        //  Ajour d'un parametre de configuration pour ne pas envoye les requetes de debug pour rien...
        //

        if (bLog != undefined && bLog == true) {

            var trace = "Browser-Ajax |" + _data;
            //iCommon.callServerMethod(this.page.url, "DebugMonitoring", { data: trace },
            //       function (_result) {
            //           return;
            //       },
            //       function (_xhr, msg, e) {

            //       }, null
            //   );
        }

        return;
    },


    //
    //  Methode qui permet de tracer les operations de supervisions qui sont 
    //  en error.
    //

    _error: function (_data, postpone) {

        if (postpone != undefined || postpone == true) {
            setTimeout(function () { AudioMonitoring._error(_data, false); }, 1);
            return;
        }

        if (console != undefined)
            console.log("error: " + _data);

        var trace = "Browser-Ajax |" + _data;
        // iCommon.callServerMethod(this.page.url, "ErrorMonitoring", { data: trace },
        //        function (_result) {
        //            return;
        //        },
        //        function (_xhr, msg, e) {
        //        }, null
        //);


    },


    _warning: function (_data, postpone) {

        if (postpone != undefined || postpone == true) {
            setTimeout(function () { AudioMonitoring._warning(_data, false); }, 1);
            return;
        }

        var trace = "|Browser-Ajax |" + _data;
        if (console != undefined)
            console.log("warning: " + trace);

        //iCommon.callServerMethod(this.page.url, "WarningMonitoring", { data: trace },
        //       function (_result) {
        //           return;
        //       },
        //       function (_xhr, msg, e) {
        //       }, null
        //);


    },


    alert: function (result, defaultmessage, callback) {

        var alertmsg = DialogResources.Get(result.m_szReason, result, defaultmessage);
        this._error(result.m_szCmd + ": ", alertmsg, true);


        //
        //  Les alertes sont disponibles pour certaines commandes seulement.
        //
        if (this.alertEnable.indexOf(result.m_szCmd) < 0)
            return;


        if (Dialog == undefined || Dialog == null)
            return;

        Dialog.createAlertDialog(alertmsg, callback);
        return;
    },

    httpAlert: function (id, command, message) {

        this._error(id + ": ", message, true);

        if (Dialog == undefined || Dialog == null)
            return;

        //
        //  Les alertes sont disponibles pour certaines commandes seulement.
        //
        if (this.alertEnable.indexOf(command) < 0)
            return;

        var data = { m_szCmd: command, m_szSystemError: message }
        var alertmsg = DialogResources.Get(id, data, id + ":( " + command + " ) " + message);

        Dialog.createAlertDialog(alertmsg, AudioMonitoringFsm.openwindow);
        return;
    }
};